#!/usr/local/bin/bash

#beep_enable=1
bios_file_apu2b2="/root/apu20150928_1333.rom"
bios_file_apu2b4="/root/apu20150928.rom"
bios_date="09/28/2015"
total_nics=3
total_sata=4

version="1.02"
pciids="/usr/local/share/lshw/pci.ids"
pciids_tmp="/tmp/pci.ids"
lshwtxt="/tmp/lshw.txt"
lshwstxt="/tmp/lshws.txt"

ip0=192.168.100.100
ip1=192.168.100.101
ip2=192.168.100.102

eth0_status=1
eth1_status=1
eth2_status=1

complete_test_status=1;

tab1=45


#print_result "text to print" [0:1] (0 = red & bold)
function print_result(){
	#term_ypos=`tput col`;
	#term_xpos=`tput line`;
	#tput cup $tab1 `tput line`;
	tput el
	tput cup `tput col` $tab1;
	if [ "$2" = "0" ]; then
		tput sgr0
		tput bold
		tput setaf 1
		printf " !!!!! "
	else
		tput sgr0
		tput bold
		tput setaf 2
	fi
	printf ": $1"
	tput sgr0
	echo
}

function get_hw_inventory(){
	#retrieve hardware information for several tests
	echo -n "collecting hardware information ..."
	if [ -f $pciids ] ; then mv $pciids $pciids_tmp; fi
	#if [ ! -f $lshwtxt ]; then lshw -short -quiet > $lshwtxt; fi
	if [ ! -f $lshwtxt ]; then lshw -quiet > $lshwtxt; fi
	if [ ! -f $lshwstxt ]; then lshw -short -quiet > $lshwstxt; fi
	if [ -f $pciids_tmp ] ; then mv $pciids_tmp $pciids; fi
	tput cup `tput col` 0;
	tput el
	#print_result "DONE" 1
}

function fail_beep(){
	if [ "$beep_enable" = "1" ]; then 	
		beep -f 1000 -l 500 -r 3 -d 100 &
	fi
}

function fail(){
	if [ "$beep_enable" = "1" ]; then 	
		beep -f 1000 -l 1500 &
	fi
	tput sgr0
	tput bold
	tput setaf 1
	echo
	echo "#######    #      ###   #"
	echo "#         # #      #    #"
	echo "#        #   #     #    #"
	echo "#####   #     #    #    #"
	echo "#       #######    #    #"
	echo "#       #     #    #    #"
	echo "#       #     #   ###   #######"
	echo
	tput sgr0
}

function pass(){
	tput sgr0
	tput bold
	tput setaf 2
	echo
	echo "######     #     #####   #####"
	echo "#     #   # #   #     # #     #"
	echo "#     #  #   #  #       #"
	echo "######  #     #  #####   #####"
	echo "#       #######       #       #"
	echo "#       #     # #     # #     #"
	echo "#       #     #  #####   #####"
	echo
	tput sgr0
}

function assign_ip(){
	if [ "$eth_from" = "eth0" ]; then ip_from=$ip0; fi
	if [ "$eth_from" = "eth1" ]; then ip_form=$ip1; fi
	if [ "$eth_from" = "eth2" ]; then ip_from=$ip2;	fi

	if [ "$eth_to" = "eth0" ]; then	ip_to=$ip0;	fi
	if [ "$eth_to" = "eth1" ]; then	ip_to=$ip1;	fi
	if [ "$eth_to" = "eth2" ]; then	ip_to=$ip2;	fi
}

function init_nics(){

	ifconfig eth0 down > /dev/null 2>&1
	ifconfig eth1 down > /dev/null 2>&1
	ifconfig eth2 down > /dev/null 2>&1
	while [  `cat /sys/class/net/eth0/operstate` = "up" ] ; do usleep 100; done
	while [  `cat /sys/class/net/eth1/operstate` = "up" ] ; do usleep 100; done
	while [  `cat /sys/class/net/eth2/operstate` = "up" ] ; do usleep 100; done
	
	ifconfig eth0 $ip0 netmask 255.255.255.0 > /dev/null 2>&1
	ifconfig eth1 $ip1 netmask 255.255.255.0 > /dev/null 2>&1
	ifconfig eth2 $ip2 netmask 255.255.255.0 > /dev/null 2>&1

	#wait until the nic's are up again ...
	timeout=0
	nic_updown_status=1
	tput sc
	echo -n "NICs are getting ready ."
	while	[  `cat /sys/class/net/eth0/operstate` = "down" ] || [  `cat /sys/class/net/eth1/operstate` = "down" ] || [  `cat /sys/class/net/eth2/operstate` = "down" ]; do
		sleep 1
		echo -n .
		timeout=$(( timeout + 1 ))
		if [ "$timeout" -gt "7" ] ; then 
			nic_updown_status=0
			break
		fi
	done

	#set cursor position to x=0
	tput el1
	tput rc
		
	if [ "$nic_updown_status" = "1" ] ; then
		#let it rest another 1s 
		sleep 1
	else
		if [  `cat /sys/class/net/eth0/operstate` = "down" ] ; then 
			echo -n "failed to bring interface eth0 up"
			print_result "FAIL" 0
			eth0_status=0
			#echo -n " "
		fi
		if [  `cat /sys/class/net/eth1/operstate` = "down" ] ; then 
			echo -n "failed to bring interface eth1 up"
			print_result "FAIL" 0
			eth1_status=0
			#echo -n " "
		fi
		if [  `cat /sys/class/net/eth2/operstate` = "down" ] ; then 
			echo -n "failed to bring interface eth2 up"
			print_result "FAIL" 0
			eth2_status=0
			#echo -n " "
		fi
		complete_test_status=0
	fi

}

function del_route(){
	ip route delete 192.168.100.100 dev eth0  > /dev/null 2>&1
	ip route delete 192.168.100.101 dev eth0  > /dev/null 2>&1
	ip route delete 192.168.100.102 dev eth0  > /dev/null 2>&1

	ip route delete 192.168.100.100 dev eth1  > /dev/null 2>&1
	ip route delete 192.168.100.101 dev eth1  > /dev/null 2>&1
	ip route delete 192.168.100.102 dev eth1  > /dev/null 2>&1

	ip route delete 192.168.100.100 dev eth2  > /dev/null 2>&1
	ip route delete 192.168.100.101 dev eth2  > /dev/null 2>&1
	ip route delete 192.168.100.102 dev eth2  > /dev/null 2>&1
}

function do_ping(){
	eth_status=0

	ip route add $ip_to dev $eth_from > /dev/null 2>&1
	ip route add $ip_from dev $eth_to > /dev/null 2>&1

	ip route flush table 100 > /dev/null 2>&1

	ip rule add iif $eth_from lookup 100 > /dev/null 2>&1
	ip rule add iif $eth_to lookup 100 > /dev/null 2>&1

	ip route add local $ip_from dev $eth_from table 100 > /dev/null 2>&1
	ip route add local $ip_to dev $eth_to table 100 > /dev/null 2>&1

	tput cup `tput col` 0;
	echo -n "ping from $eth_from to $eth_to"

	ping -q -c 1 $ip_to > /dev/null && eth_status=1
	if [ "$eth_status" = 1 ]; then
		print_result "PASS" 1
		#echo ": PASS"
		echo -n " "
	else
		print_result "FAIL" 0
		#echo ": FAIL"
		#fail
	fi

	del_route
}

function check_eths(){
	#init_nics

##########################################################################
	eth_from=eth0
	eth_to=eth1
	
	ip_from=$ip0
	ip_to=$ip1

	ip route del $ip1 table local > /dev/null 2>&1
	if [ "$eth0_status" = "1" ] && [ "$eth1_status" = "1" ] ; then  
		do_ping; 
		eth1_status=$eth_status
	fi

	ip route add local $ip_to dev $eth_to table local proto kernel src $ip_to > /dev/null 2>&1

##########################################################################
	eth_from=eth0
	eth_to=eth2
	
	ip_from=$ip0
	ip_to=$ip2

	ip route del $ip1 table local > /dev/null 2>&1
	if [ "$eth0_status" = "1" ] && [ "$eth2_status" = "1" ] ; then  
		do_ping; 
		eth2_status=$eth_status
	fi

	ip route add local $ip_to dev $eth_to table local proto kernel src $ip_to > /dev/null 2>&1

##########################################################################
	eth_from=eth1
	eth_to=eth0
	
	ip_from=$ip0
	ip_to=$ip1

	ip route del $ip1 table local > /dev/null 2>&1
	if [ "$eth0_status" = "1" ] && [ "$eth1_status" = "1" ] ; then  
		do_ping; 
		eth0_status=$eth_status
	fi

	ip route add local $ip_to dev $eth_to table local proto kernel src $ip_to > /dev/null 2>&1

##########################################################################
	eth_from=eth1
	eth_to=eth2
	
	ip_from=$ip0
	ip_to=$ip1

	ip route del $ip1 table local > /dev/null 2>&1
	if [ "$eth1_status" = "1" ] && [ "$eth2_status" = "1" ] ; then  
		do_ping; 
		eth2_status=$eth_status
	fi

	ip route add local $ip_to dev $eth_to table local proto kernel src $ip_to > /dev/null 2>&1

##########################################################################
	eth_from=eth2
	eth_to=eth0
	
	ip_from=$ip0
	ip_to=$ip1

	ip route del $ip1 table local > /dev/null 2>&1
	if [ "$eth0_status" = "1" ] && [ "$eth2_status" = "1" ] ; then  
		do_ping; 
		eth0_status=$eth_status
	fi

	ip route add local $ip_to dev $eth_to table local proto kernel src $ip_to > /dev/null 2>&1

##########################################################################
	eth_from=eth2
	eth_to=eth1
	
	ip_from=$ip0
	ip_to=$ip1

	ip route del $ip1 table local > /dev/null 2>&1
	if [ "$eth2_status" = "1" ] && [ "$eth1_status" = "1" ] ; then  
		do_ping; 
		eth1_status=$eth_status
	fi

	ip route add local $ip_to dev $eth_to table local proto kernel src $ip_to > /dev/null 2>&1

}


function check_nic_count(){
	# check correct amount of network interfaces
	echo -n "counting number of NICs"
	#nr_of_nics=`cat $lshwtxt | grep -i ethernet | grep -v dummy | wc -l`
	nr_of_nics=`lspci -i /usr/local/share/lshw/pci.ids | grep "Ethernet controller" | wc -l`
	#nr_of_nics=`cat $lshwtxt | grep -i ethernet | grep -i pciexpress | wc -l`
	if [ "$nr_of_nics" = "$total_nics" ]; then
		print_result "PASS, $total_nics NICs found" 1
	else
		if ! [ `cat $lshwtxt | grep eth0 | wc -l` = 1 ]; then
			print_result "FAIL eth0 is missing!" 0
			#echo ": FAIL eth0 is missing!"
		fi
		if ! [ `cat $lshwtxt | grep eth1 | wc -l` = 1 ]; then
			print_result "FAIL eth1 is missing!" 0
			#echo ": FAIL eth1 is missing!"
		fi
		if ! [ `cat $lshwtxt | grep eth2 | wc -l` = 1 ]; then
			print_result "FAIL eth2 is missing!" 0
			#echo ": FAIL eth2 is missing!"
		fi
		fail_beep
		complete_test_status=0
	fi
}

function check_macadr(){
	echo -n "checking MAC addresses"
	mac_status=1
	macadr_eth0=`ifconfig eth0 | grep -o -E '([[:xdigit:]]{1,2}:){5}[[:xdigit:]]{1,2}'`
	macadr_eth1=`ifconfig eth1 | grep -o -E '([[:xdigit:]]{1,2}:){5}[[:xdigit:]]{1,2}'`
	macadr_eth2=`ifconfig eth2 | grep -o -E '([[:xdigit:]]{1,2}:){5}[[:xdigit:]]{1,2}'`
	oui_eth0=`echo $macadr_eth0 | head -c 8`
	oui_eth1=`echo $macadr_eth1 | head -c 8`
	oui_eth2=`echo $macadr_eth2 | head -c 8`

	nic_eth0=`echo $macadr_eth0 | tail -c 8`
	nic_eth1=`echo $macadr_eth1 | tail -c 8`
	nic_eth2=`echo $macadr_eth2 | tail -c 8`

	#check if OUI is set correct
	if ! [ "$oui_eth0" = "00:0D:B9" ]; then 
		if [ "$mac_status" = "1" ]; then print_result "FAIL" 0; fi				
		mac_status=0; 
		echo -n "MAC address of eth0 is not set correct"
		print_result "$macadr_eth0" 0
	fi
	if ! [ "$oui_eth1" = "00:0D:B9" ]; then
		if [ "$mac_status" = "1" ]; then print_result "FAIL" 0; fi				
		mac_status=0; 
		echo -n "MAC address of eth1 is not set correct"
		print_result "$macadr_eth1" 0
	fi
	if ! [ "$oui_eth2" = "00:0D:B9" ]; then 
		if [ "$mac_status" = "1" ]; then print_result "FAIL" 0; fi				
		mac_status=0; 
		echo -n "MAC address of eth2 is not set correct"
		print_result "$macadr_eth2" 0
	fi
	
	#check if all MAC addresses are unique
	if [ "$nic_eth0" = "$nic_eth1" ] || [ "$nic_eth0" = "$nic_eth2" ] || [ "$nic_eth1" = "$nic_eth2" ]; then 
		if [ "$mac_status" = "1" ]; then print_result "FAIL" 0; fi				
		mac_status=0; 
		echo -n "MAC addresses are not unique:"
		print_result "$macadr_eth0" 0
		print_result "$macadr_eth1" 0
		print_result "$macadr_eth2" 0		
	fi
	#print final result of MAC test
	if [ "$mac_status" = "1" ]; then
		print_result "PASS" 1
	else
		fail_beep
		complete_test_status=0
	fi
}	

function check_nic_traffic(){
	echo "checking network traffic"
	check_eths

	nic_status=1
	tput cup `tput col` 0;
	tput el
	
	if [ "$eth0_status" = "0" ] ; then 
		echo -n "traffic on eth0"; 
		print_result "FAIL eth0" 0;
		nic_status=0 
	fi
	if [ "$eth1_status" = "0" ] ; then 
		echo -n "traffic on eth1"; 
		print_result "FAIL eth1" 0; 
		nic_status=0 
	fi
	if [ "$eth2_status" = "0" ] ; then 
		echo -n "traffic on eth2"; 
		print_result "FAIL eth2" 0; 
		nic_status=0 
	fi
	if [ "$nic_status" = "1" ]; then
		echo -n "checking network traffic"
		#clear line and move cursor 1 up
		#tput cup `tput col` 0;
		#tput el
		#tput cuu1
		print_result "PASS" 1
	#fi
	else	
	#if [ "$eth0_status" = 0 ] || [ "$eth1_status" = 0 ] || [ "$eth2_status" = 0 ] ; then
		fail_beep
		complete_test_status=0
	fi

}

function check_usb(){
	usb_devices_found=0
	usb_status=0
	number_of_usb_sticks=1
	c=0
	usb_count=0
	echo "checking USB devices"
	while [ "$usb_devices_found" = "0" ]; do
		for i in $(seq 1 $number_of_usb_sticks)
		do
			if [ `find /media/| grep "$i".txt | wc -l` = 1 ]; then
				usb_count=$(($usb_count + 1))
			fi
		done
		if [ $usb_count = $number_of_usb_sticks ]; then
			usb_devices_found=1
			print_result "PASS" 1
			break
		fi
		c=$((c + 1))
		if [ "$c" > $number_of_usb_sticks ]; then
			complete_test_status=0
			usb_status=0
			echo -n "USB devices not found"
			print_result "FAIL" 0
			fail_beep
			break
		fi     
	done
	for i in $(seq 1 $number_of_usb_sticks)
	do
		if ! [ `find /media/| grep "$i".txt | wc -l` = 1 ]; then
			echo -n "USB Nr.$i not found"
			print_result "FAIL" 0
			complete_test_status=0
			usb_status=1
			fail_beep
		else
			echo -n "USB $i test"
			print_result "PASS" 1
			#usb_status=0
			#break
		fi
	done
}


function check_msata(){
	echo -n "testing mSATA presence"
	sata=`cat $lshwtxt  | grep -i ata | wc -l`
	if ! [ "$sata" = "2" ]; then 	
		fail_beep
		print_result "FAIL, NO SATA DEVICE FOUND!" 0
		complete_test_status=0
	else
		print_result "PASS" 1
	fi

	#ls -1 /sys/class/ata_port/
}


function list_system(){
	#echo -n "CPU"
	#print_result "`cat $lshwtxt | grep -i processor | grep AMD | tail -c 21`" 1
	echo -n "System Memory"
	print_result `cat /proc/meminfo | grep MemTotal | awk '{ print $2 }'` kB
	#print_result "`cat $lshwstxt | grep -i "System memory"| tail -c 22`"
}

function check_bios(){
	echo -n checking BIOS version ...
	if ! [ `dmidecode | grep Date | tr '\ ' '\n' | tail -n 1` = $bios_date ]; then
		print_result "old BIOS found" 0
		print_result "flashing new BIOS $bios_date" 0
		echo
		print_result "!!! DO NOT POWER OFF !!!" 0
		echo
		if [ `free -m | head -n2 | tail -n1 | awk '{print $2}'` = "1897" ]
		then
			flashrom -w $bios_file_apu2b4 -p internal
			print_result "I211 initialized" 0				
		else
			flashrom -w $bios_file_apu2b2 -p internal
			print_result "I210 initialized" 0				
		fi

		print_result "REBOOTING NOW ..." 0
		reboot
		sleep 10
	fi
	print_result "PASS, correct BIOS found $bios_date" 1
}

function init_intel_nics(){
	echo -n initializing Intel NICs ...

	macadr_eth0=`ifconfig eth0 | grep -o -E '([[:xdigit:]]{1,2}:){5}[[:xdigit:]]{1,2}'`
	macadr_eth1=`ifconfig eth1 | grep -o -E '([[:xdigit:]]{1,2}:){5}[[:xdigit:]]{1,2}'`
	macadr_eth2=`ifconfig eth2 | grep -o -E '([[:xdigit:]]{1,2}:){5}[[:xdigit:]]{1,2}'`
	if [ "$macadr_eth0" = "$macadr_eth1" ]; then 	
		echo "network UNCLAIMED" >> $lshwtxt		#what a hack ...
	fi

	if ! [ `cat $lshwtxt | grep -i "network UNCLAIMED" | wc -l` = "0" ]; then		
		print_result "initializing NICs ..." 0
		echo -n "Enter serial number: "
		read sn
		sn=`echo $sn | tr '_' '\n' | head -n 1`
		sn=`echo "${sn//[!0-9]/}"`

		mac=$(expr $sn + 64)
		mac=$(expr $mac \* 4)
		mac1=`printf 000db9%06x $mac`
		mac=$(expr $mac + 1)
		mac2=`printf 000db9%06x $mac`
		mac=$(expr $mac + 1)
		mac3=`printf 000db9%06x $mac`
		echo 1st MAC adr = $mac1
		echo 2nd MAC adr = $mac2
		echo 3rd MAC adr = $mac3

		#./apu2/eeupdate32 /NIC=1
		eeupdate32 /NIC=1 /MAC=$mac1 > /dev/null
		eeupdate32 /NIC=2 /MAC=$mac2 > /dev/null
		eeupdate32 /NIC=3 /MAC=$mac3 > /dev/null

		#determine RAM size
		#free -m | head -n2 | tail -n1 | awk '{print $2}'
		#1897
		if [ `free -m | head -n2 | tail -n1 | awk '{print $2}'` = "1897" ]
		then
				eeupdate32 /NIC=1 /INVMUPDATE /FILE=I211_Invm_APM_v0.6.txt > /dev/null
				eeupdate32 /NIC=2 /INVMUPDATE /FILE=I211_Invm_APM_v0.6.txt > /dev/null
				eeupdate32 /NIC=3 /INVMUPDATE /FILE=I211_Invm_APM_v0.6.txt > /dev/null
				print_result "I211 initialized" 0				
		else
				eeupdate32 /NIC=1 /INVMUPDATE /FILE=/root/I210_Invm_Copper_APM_v0.6.txt > /dev/null
				eeupdate32 /NIC=2 /INVMUPDATE /FILE=/root/I210_Invm_Copper_APM_v0.6.txt > /dev/null
				eeupdate32 /NIC=3 /INVMUPDATE /FILE=/root/I210_Invm_Copper_APM_v0.6.txt > /dev/null
				print_result "I210 initialized" 0				
		fi

		print_result "REBOOTING NOW ..." 0
		reboot
		sleep 10
	fi
	print_result "NIC's initialized!" 1
}


#echo starting APU test sequence V$version
echo starting APU test $version
echo

check_bios
get_hw_inventory
init_intel_nics
list_system
echo
echo
init_nics
check_nic_count
check_macadr
check_nic_traffic
#check_msata
check_usb
if [ $complete_test_status = "0" ]; then fail; else pass; fi



